"""
HB_Instancer V1.1

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_Instancer
Description-US: Converts selected Objects to Renderinstances while the last selected is the Reference


Name-DE: HB_Instancer
Description-DE: Macht Renderinstanzen und referenziert das letzte selektierte Objekt

ChangeLog:

Jun/11/2015 V1.0
- Release Version

Oct/11/2018 V1.1
- New Highres Icon

"""

import c4d

def main():
    doc = c4d.documents.GetActiveDocument()
    doc.StartUndo()
    c4dVersion= c4d.GetC4DVersion()
    ObjList = doc.GetOrderedActiveObjects()

    if len(ObjList)==1:
        Name=ObjList[0].GetName()
        Posobj=ObjList[0].GetMl()
        Instance=c4d.BaseObject(c4d.Oinstance)
        Instance[c4d.INSTANCEOBJECT_LINK]=ObjList[0]
        if c4dVersion >= 20000:
            Instance[c4d.INSTANCEOBJECT_RENDERINSTANCE_MODE]=1
        else:
            Instance[c4d.INSTANCEOBJECT_RENDERINSTANCE]=True
            
        Instance.SetName("Instance of "+Name)
        Instance.SetMl(Posobj)
        doc.AddUndo(c4d.UNDOTYPE_NEW, Instance)
        Instance.InsertAfter(ObjList[0])

    LastObject = ObjList[len(ObjList)-1]
    Name=LastObject.GetName()
    if not ObjList: return


    for obj in ObjList:

        Posobj=obj.GetMl()

        Instance=c4d.BaseObject(c4d.Oinstance)
        Instance[c4d.INSTANCEOBJECT_LINK]=LastObject
        if c4dVersion >= 20000:
            Instance[c4d.INSTANCEOBJECT_RENDERINSTANCE_MODE]=1
        else:
            Instance[c4d.INSTANCEOBJECT_RENDERINSTANCE]=True
        Instance.SetName("Instance of "+Name)
        Instance.SetMl(Posobj)
        doc.AddUndo(c4d.UNDOTYPE_CHANGE, obj)
        if obj is not LastObject:
            doc.AddUndo(c4d.UNDOTYPE_NEW, Instance)
            Instance.InsertBefore(obj)

            obj.Remove()


    doc.EndUndo()
    c4d.EventAdd()

if __name__=='__main__':
    main()